//---------------------------------------------------------------------------
#include <vcl\vcl.h>
#pragma hdrstop

#include "AsmWiz1.h"
#include "Unit1.h"
#include "Unit2.h"
#include "inifiles.hpp"
#include "scrf.hpp"
#include <dir.h>
#include <sysutils.hpp>
//---------------------------------------------------------------------------
#pragma resource "*.dfm"
TAsmWiz *AsmWiz;
//---------------------------------------------------------------------------
__fastcall TAsmWiz::TAsmWiz(TComponent* Owner)
    : TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TAsmWiz::Button3Click(TObject *Sender)
{
Close();    
}
//---------------------------------------------------------------------------
void __fastcall TAsmWiz::FormShow(TObject *Sender)
{
  Edit2->Text = Form1->DirInfo.ProjectPath;
  TIniFile* IniFile = new TIniFile( ExtractFilePath(ParamStr(0)) + "\compilers.ini");
  try
  {
    IniFile->ReadSections( ComboBox1->Items);
  }
  catch( ... )
  {
    IniFile->Free();
    throw;
  }
  IniFile->Free();
  ComboBox1->Text = Form1->AssemblerInfo.Assembler;

}
//---------------------------------------------------------------------------
void __fastcall TAsmWiz::Button1Click(TObject *Sender)
{
 Form1->FileOpenDlg->Filter = "ASM  source files (*.asm)|*.ASM";
 Form1->FileOpenDlg->InitialDir = Form1->DirInfo.BasePath + "\Templates";
 if (Form1->FileOpenDlg->Execute()){
     ListBox1->Items->Add( Form1->FileOpenDlg->FileName);
 }
}
//---------------------------------------------------------------------------
void __fastcall TAsmWiz::CodeGeneration()
{
TStringList *Buffer;
TSourceCode *SourceCode;
TCodeElement *CodeElement;

mkdir( Form1->ProjectInfo.Path.c_str() );
AnsiString SCRPath = Form1->DirInfo.ModulePath + "\\asmcode.scr";
char * SCROwner = "AsmCode";
Form1->ProjectInfo.MainData = Form1->ProjectInfo.Path + "\\MainData.asm";
Form1->ProjectInfo.MainAsm = Form1->ProjectInfo.Path + "\\MainCode.asm";
Form1->ProjectInfo.UserProc =  Form1->ProjectInfo.Path + "\\UserProc.asm";
Form1->ProjectInfo.IniFile =  Form1->ProjectInfo.Path + "\\project.ini";

int i;
Buffer = new TStringList;
try
{
 SourceCode=new TSourceCode( SCRPath.c_str() , SCROwner );
 if (SourceCode){
   if (RadioButton1->Checked) CodeElement=SourceCode->Block( "WinAsmSetup" );
   else if (RadioButton3->Checked) CodeElement=SourceCode->Block( "DllAsmSetup" );
   else CodeElement=SourceCode->Block( "AsmSetup" );
   if (CodeElement) {
     for (i=1;i<=CodeElement->numLines();i++)
         Buffer->Add( CodeElement->Line(i)->Text() );
     Buffer->SaveToFile(Form1->ProjectInfo.MainAsm);
     Form1->ProjectInfo.AsmFiles->Append( Form1->ProjectInfo.MainAsm );
   }
   //Write Data Module
   Buffer->Clear();
   Buffer->Add(".data");
   if (Form1->ProjectInfo.IsWin32) Buffer->Append("INCLUDE WIN32.INC");
   Buffer->SaveToFile( Form1->ProjectInfo.MainData);
   Form1->ProjectInfo.AsmFiles->Add( Form1->ProjectInfo.MainData );
   //Write PROC Module
   Buffer->Clear();
   Buffer->Add("; Add user and system procedures called by the main code here");
   Buffer->SaveToFile( Form1->ProjectInfo.UserProc);
   Form1->ProjectInfo.AsmFiles->Add(Form1->ProjectInfo.UserProc );
   Buffer->Free();
 delete (SourceCode);
 }
 else Form2->MessageEdit->Lines->Add(SCRPath + " Not Found at given location!");
}
catch (...)
{
Form2->MessageEdit->Lines->Add(SCRPath + " Not Found!");
Form2->MessageEdit->Lines->Add("Error Loading SCR file");
} 


}
void __fastcall TAsmWiz::Button2Click(TObject *Sender)
{
AnsiString CompileString, LinkString;
 int x;
Form1->ProjectInfo.Assembler = ComboBox1->Text;
Form1->ProjectInfo.Title = Edit1->Text;
if (RadioButton1->Checked || RadioButton3->Checked) Form1->ProjectInfo.IsWin32 = TRUE;
else Form1->ProjectInfo.IsWin32 = FALSE;
Form1->ProjectInfo.Path = Edit2->Text + Edit1->Text;
if (ListBox1->Items->Count > 0) Form1->ProjectInfo.AsmFiles->AddStrings(ListBox1->Items);
CodeGeneration();
TIniFile* IniFile2 = new TIniFile( Form1->DirInfo.BasePath + "\\compilers.ini");
try
    {
    CompileString = IniFile2->ReadString(ComboBox1->Text, "Compile", "Compiler Not Found!");
    LinkString = IniFile2->ReadString(ComboBox1->Text, "Link", "Compiler Not Found!");
    for ( x = 0; x < Form1->ProjectInfo.AsmFiles->Count; x++) {
           CompileString += " " + Form1->ProjectInfo.AsmFiles->Strings[x];//ExtractFileName(Form1->ProjectInfo.AsmFiles->Strings[x].c_str());
           LinkString += " " + ChangeFileExt(ExtractFileName(Form1->ProjectInfo.AsmFiles->Strings[x].c_str()), ".o");
    }
} catch( ... )
    {
    throw;
    }
IniFile2->Free();
TIniFile* IniFile = new TIniFile( Form1->ProjectInfo.IniFile);
try
    {
      IniFile->WriteString( "Settings", "Path", Form1->ProjectInfo.Path);
      IniFile->WriteString( "Settings", "CompileString", CompileString);
      IniFile->WriteString( "Settings", "LinkString", LinkString);
      IniFile->WriteString( "Settings", "Title", Form1->ProjectInfo.Title);
      IniFile->WriteBool( "Settings", "IsWin32", Form1->ProjectInfo.IsWin32);
      IniFile->WriteString( "Settings", "CompileString", "");
      IniFile->WriteString( "Settings", "LinkString", "");
      IniFile->WriteString( "Main Modules", "MainASM", Form1->ProjectInfo.MainAsm);
      IniFile->WriteString( "Main Modules", "MainDATA", Form1->ProjectInfo.MainData);
      IniFile->WriteString( "Main Modules", "UserPROC", Form1->ProjectInfo.UserProc);
      for ( x = 0; x < Form1->ProjectInfo.AsmFiles->Count; x++)
           IniFile->WriteString( "ASM Modules", Form1->ProjectInfo.AsmFiles->Strings[x], "");
    }
    catch( ... )
    {
    //IniFile->Free();
    throw;
    }
IniFile->Free();
Form1->OpenProject(Form1->ProjectInfo.IniFile);
Close();
}
//---------------------------------------------------------------------------
